﻿/****** Object:  View [dbo].[ViewChequeOutReport]    Script Date: 6/21/2025 01:07:51 ب.ظ ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

ALTER VIEW [dbo].[ViewChequeOutReport]
AS
SELECT CHQ.ID, CHQ.DebitTotalID, CHQ.DebitControlID, CHQ.DebitDetailID1, CHQ.DebitDetailID2, CHQ.CreditTotalID, CHQ.CreditControlID, 
                CHQ.CreditDetailID1, CHQ.CreditDetailID2, AccDocHeader.Number AS DocNumber, CHQ.DocItemRelationID, ' ' AS BankName, ' ' AS BankBranch, CHQItem.ChequeNo, 
                CHQItem.ChequeDate, CHQItem.ChequeValue, CHQ.Description, CAST(COALESCE (CHQItem.Status, 0) AS int) AS Status, CHQItem.CashDate, 
                CashHeader.Number AS CashDocNumber, CHQItem.CashDocItemRelationID, CHQ.UpdateDate, CHQ.Updater, 
                dbo.FARSI_DATE2(CHQItem.ChequeDate) AS ChequeDatePer, CAST(0 AS bit) AS Selected, AccDocHeader.Flags, AccDocHeader.IsPermanent, CashHeader.Flags AS CashFlag, CashHeader.IsPermanent AS CashIsPermanent, 
                CHQItem.CashDocItemID, CHQ.DocItemID, DocItem.Description AS ItemDescription, CashItem.Description AS CashItemDescription, CHQItem.TotalID, CHQItem.ControlID, 
                CHQItem.DetailID1, CHQItem.DetailID2, CHQDebit.TotalID AS PersonTotalID, CHQDebit.ControlID AS PersonControlID, CHQDebit.DetailID1 AS PersonDetailID1, 
                CHQDebit.DetailID2 AS PersonDetailID2, ReturnItem.Description AS ReturnDescription, ReturnHeader.Number as ReturnNumber, ReturnHeader.Flags AS ReturnFlags, ReturnHeader.IsPermanent AS ReturnIsPermanent, CHQItem.ReturnDocItemID, DocItem.HeaderID as DocHeaderID, ReturnItem.headerID as ReturnDocHeaderID, CashItem.HeaderID as CashDocHeaderID,
				CHQ.Project,CHQ.CostCenter
FROM      dbo.AccChequeOut as CHQ WITH (NOLOCK) LEFT OUTER JOIN
                dbo.AccDocHeader AS AccDocHeader WITH (NOLOCK) RIGHT OUTER JOIN
                dbo.AccDocItem AS DocItem WITH (NOLOCK) ON AccDocHeader.ID = DocItem.HeaderID ON CHQ.DocItemID = DocItem.ID LEFT OUTER JOIN
                dbo.AccDocItem AS CashItem WITH (NOLOCK) LEFT OUTER JOIN
                dbo.AccDocHeader AS CashHeader WITH (NOLOCK) ON CashItem.HeaderID = CashHeader.ID RIGHT OUTER JOIN
                dbo.AccChequeOutItemInfo as CHQItem WITH (NOLOCK) LEFT OUTER JOIN
                dbo.AccDocItem AS ReturnItem LEFT OUTER JOIN
                dbo.AccDocHeader AS ReturnHeader ON ReturnItem.HeaderID = ReturnHeader.ID ON CHQItem.ReturnDocItemID = ReturnItem.ID ON CashItem.ID = CHQItem.CashDocItemID ON 
                CHQ.ID = CHQItem.ChequeOutID LEFT OUTER JOIN
                dbo.AccChequeOutDebit as CHQDebit ON CHQ.ID = CHQDebit.ChequeOutID
GO


